'***************************************************************************************
'*                                                                                     *
'*  Ganganzeige V2.1 by Ati mit einem Open-Mini                                        *
'*                                                                                     *
'***************************************************************************************

' Ganganzeige mit integrierter Scheinwerfersteuerung und LED-Anzeige-Helligkeitssteuerung
' Dazu wird das Gangsensorsignal, die Umgebungshelligkeit und das Drehzahlmessersignal ausgewertet
' und einem integriertem Schaltblitz
' --- Betriebssystem konfigurieren ------------------------------------------
include "om.def"           ' Definitionen fuer Betriebssystem
option openmini
RunOnErr = on              ' bei Fehler Programm neustarten (Fehler in ERR)
pullupa = 0
pullupb = 0
ClockDis = on
' ---------------------------------------------------------------------------
'--- Definitionen der QT4 & QY4 Ports --------------------------------------------------
define Sensor3        ad[6]             'Eingang Sensor Umgebungshelligkeit
define Sensor1        ad[5]             'Eingang Sensor Gang
'define Sensor2      port[3]             'host/run und Sensor Drehzahl
define a            port[2]             'Ausgang a
define b            port[11]            'Ausgang b
define c            port[12]            'Ausgang c
define d            port[4]             'Ausgang d
define e            port[13]            'Ausgang e
define f            port[14]            'Ausgang f
define g            port[9]             'Ausgang g
define dp           port[15]            'Ausgang Dezimalpunkt und Lichtsteuerung
define PWM_Port     port[1]             '1. PWM Ausgang
define Relais       port[10]            'Relaissteuerausgang
define Schaltblitz  port[16]            'Schaltblitzausgang
define Flanke1      Bit[81]             'Flankenbit Schaltblitz
define tmp          byte                ' Hilfsvariable fr PWM
define k            byte                ' Gangvariable
define x            byte                ' Timervariable
define y            byte                ' Zhlervariable Ende-Timer
define p            byte                ' Variable fr PWM
define z            byte                ' Variable fr Frequenzmessung

'   Die Pinbelegung der
'    Open-Mini (QY4)     _____    _____
'                       |     \__/     |
'                      [  VDD      GND  ]       VDD = 4.6 bis 5.5 Volt
'                       |              |
'      Schaltblitz  16 [  PTB7    PTB0  ] 9     g
'                       |              |
'              dp   15 [  PTB6    PTB1  ] 10    Lichtrelais
'                       |              |
'      Lichtsensor   6 [  PTA5    PTA0  ] 1     PWM1
'                       |              |
'      Sensor Gang   5 [  PTA4    PTA1  ] 2     a
'                       |              |
'               f   14 [  PTB5    PTB2  ] 11    b
'                       |              |
'               e   13 [  PTB4    PTB3  ] 12    c
'                       |
'               d    4 [  PTA3    PTA2  ] 3     host/run Frequenzmessung
'                       |______________|
'

'--- Variablen -------------------------------------------------------------------------
tmp = 0                                    ' Wertvariable fr PWM
k = 0                                      ' Variable fr Gang
x = 0                                      ' Variable fr Timer
y = 0                                      ' Variable fr zweiten Timer
p = 0                                      ' Variable fr PWM
z = 0                                      ' Variable fr Frequenzmessung
'---------------------------------------------------------------------------------------

'--- Initialisierung Hard und Software -------------------------------------------------
' Es werden jetzt kurz eine 8 gezeigt, dann kreisen die ueren Balken und dann werden die Zahlen 0 bis 6 angezeigt.
' Danach begint dass eigentliche Programm.
'--------------------
pwm1_ein                                        ' Einschalten des PWM
tmp = 250                                       ' LED-Helligkeit 100%
pwm1 tmp                                        ' Datenzuweisung fr PWM1
Initial                                         ' Anzeige auf- und abschwellende 8 auf dem Display
Display_init                                    ' kreisende Balken
Leerlauf : pause 8                              ' Anzeige 0 auf dem Display
Gang_1 : pause 10                               ' Anzeige 1 auf dem Display
Gang_2 : pause 10                               ' Anzeige 2 auf dem Display
Gang_3 : pause 10                               ' Anzeige 3 auf dem Display
Gang_4 : pause 10                               ' Anzeige 4 auf dem Display
Gang_5 : pause 10                               ' Anzeige 5 auf dem Display
Gang_6 : pause 10                               ' Anzeige 6 auf dem Display
Fehler : pause 10                               ' Anzeige E auf dem Display
Blitz
pause 6
Blitz
pause 6
Blitz
'---------------------------------------------------------------------------------------

'--- Hauptprogramm ---------------------------------------------------------------------
' Es werden nun alle 0,5 Sekunden die Sensoren abgefragt.
'--------------------
#start
'Gangkontrolle                                          
'Programmanfang  
'Gangkontrolle bei laufendem Motor
if Sensor1>=71 and Sensor1<=105 and Relais = on then
     gosub Gang_1                               'Anzeige - Gang 1 Sensorspannung 1,15 Volt - am Pin 1,94 Volt
else if Sensor1>=106 and Sensor1<=128 and Relais = on then
     gosub Gang_2                               'Anzeige - Gang 2 Sensorspannung 2,4 Volt - am Pin 2,38Volt
else if Sensor1>=129 and Sensor1<=170 and Relais = on then
     gosub Gang_3                               'Anzeige - Gang 3 Sensorspannung 3,1 Volt - am Pin 3,06 Volt
else if Sensor1>=171 and Sensor1<=197 and Relais = on then
     gosub Gang_4                               'Anzeige - Gang 4 Sensorspannung 3,8 Volt - am Pin 3,68 Volt
else if Sensor1>=198 and Sensor1<=227 and Relais = on then
     gosub Gang_5                               'Anzeige - Gang 5 Sensorspannung 4,43 Volt - am Pin 4,37 Volt
else if Sensor1>=228 and Sensor1<=246 and Relais = on then
     gosub Gang_6                               'Anzeige - Gang 6 Sensorspannung 4,77 Volt - am Pin 4,67 Volt
else if Sensor1>=247 and Relais = on then
     gosub Leerlauf                             'Anzeige - Leerlauf Sensorspannung 4,93 Volt - am Pin 4,9 Volt
else if Sensor1>=0 and Sensor1<70 and Relais = on then
     gosub Fehler                               'Anzeige - Error
'Gangkontrolle bei stehendem Motor
else if Sensor1>=83 and Sensor1<=105 and Relais = off then
     gosub Gang_1                               'Anzeige - Gang 1 Sensorspannung 1,95 Volt
else if Sensor1>=106 and Sensor1<=128 and Relais = off then
     gosub Gang_2                               'Anzeige - Gang 2 Sensorspannung 2,4 Volt
else if Sensor1>=129 and Sensor1<=165 and Relais = off then
     gosub Gang_3                               'Anzeige - Gang 3 Sensorspannung 3,16 Volt
else if Sensor1>=166 and Sensor1<=197 and Relais = off then
     gosub Gang_4                               'Anzeige - Gang 4 Sensorspannung 3,8 Volt
else if Sensor1>=198 and Sensor1<=221 and Relais = off then
     gosub Gang_5                               'Anzeige - Gang 5 Sensorspannung 4,47 Volt
else if Sensor1>=222 and Sensor1<=239 and Relais = off then
     gosub Gang_6                               'Anzeige - Gang 6 Sensorspannung 4,81 Volt
else if Sensor1>=240 and Relais = off then
     gosub Leerlauf                             'Anzeige - Leerlauf Sensorspannung 5,12 Volt
else if Sensor1>=0 and Sensor1<82 and Relais = off then
     gosub Fehler                               'Anzeige - Error
end if
'Lichtkontrolle
freq = 25                                       'Torzeit 0,5 Sekunden
z = freq                                        'bernahme des Impulszhler-Messwertes
if z > 7 then
     gosub Licht_on                             'Drehzahl grer ca. 720 U/min (Anlasserdrehzahl ca. 160 U/min)
else if z <= 7 then
     gosub Licht_off                            'Drehzahl kleiner ca. 720 U/min
end if
'Schaltblitz - 6.Gang braucht ja wohl eigentlich keinen ;-)
'if z>=92 and k=6 then goto setz1                ' Drehzahl 11000 U/min erreicht und 6. Gang? Ja, dann setze EIN-Flanke und Blitze
if z>=90 and k=5 then goto setz1                ' Drehzahl 10800 U/min erreicht und 5. Gang? Ja, dann setze EIN-Flanke und Blitze
if z>=88 and k=4 then goto setz1                ' Drehzahl 10600 U/min erreicht und 4. Gang? Ja, dann setze EIN-Flanke und Blitze
if z>=85 and k=3 then goto setz1                ' Drehzahl 10200 U/min erreicht und 3. Gang? Ja, dann setze EIN-Flanke und Blitze
if z>=83 and k=2 then goto setz1                ' Drehzahl 10000 U/min erreicht und 2. Gang? Ja, dann setze EIN-Flanke und Blitze
if z>=82 and k=1 then goto setz1                ' Drehzahl 9800 U/min erreicht und 1. Gang? Ja, dann setze EIN-Flanke und Blitze
Flanke1 = 0                                     ' FlankenBit off setzen (bei Nichterreichung der Drehzahl)
goto weiter
#setz1
if Flanke1 then goto weiter                     ' Ein-Flanke gesetzt? Ja, dann #weiter oder Nein, dann nchster Schritt
Flanke1 = on                                    ' Setze Ein-Flanke
gosub Blitz                                     ' Blitzen
#weiter
'Umgebungshelligkeit
if Sensor3<=105 then
     tmp = 40                   'Anzeige - dunkelleuchtend
else if Sensor3>=106 and Sensor3<=112 then
     tmp = 50  'Anzeige - heller1
else if Sensor3>=113 and Sensor3<=119 then
     tmp = 60  'Anzeige - heller2
else if Sensor3>=120 and Sensor3<=126 then
     tmp = 700 'Anzeige - heller3
else if Sensor3>=127 and Sensor3<=132 then
     tmp = 80  'Anzeige - heller4
else if Sensor3>=133 and Sensor3<=138 then
     tmp = 90  'Anzeige - heller5
else if Sensor3>=139 and Sensor3<=144 then
     tmp = 100 'Anzeige - heller6
else if Sensor3>=145 and Sensor3<=150 then
     tmp = 110 'Anzeige - heller7
else if Sensor3>=151 and Sensor3<=156 then
     tmp = 120 'Anzeige - heller8
else if Sensor3>=157 and Sensor3<=163 then
     tmp = 130 'Anzeige - heller9
else if Sensor3>=164 and Sensor3<=170 then
     tmp = 140 'Anzeige - heller10
else if Sensor3>=171 and Sensor3<=176 then
     tmp = 150 'Anzeige - heller11
else if Sensor3>=177 and Sensor3<=282 then
     tmp = 160 'Anzeige - heller12
else if Sensor3>=183 and Sensor3<=188 then
     tmp = 170 'Anzeige - heller13
else if Sensor3>=189 and Sensor3<=195 then
     tmp = 180 'Anzeige - heller14
else if Sensor3>=196 and Sensor3<=201 then
     tmp = 190 'Anzeige - heller15
else if Sensor3>=202 and Sensor3<=208 then
     tmp = 200 'Anzeige - heller16
else if Sensor3>=209 and Sensor3<=215 then
     tmp = 210 'Anzeige - heller17
else if Sensor3>=216 and Sensor3<=222 then
     tmp = 230 'Anzeige - heller18
else if Sensor3>=223 then
     tmp = 250                  'Anzeige - ganz hell
end if
pwm1 tmp
                                                'Wartezeit fr neue Abfragen
pause 3 				        'Pause 60 Millisekunden
goto start                                      'zum Programmanfang
'---------------------------------------------------------------------------------------

'--- Display init -----------------------------------------------------------------------
' die ueren Balkensegmente kreisen im Uhrzeigersinn
'--------------------
FUNC Display_init
x = Timer                                       ' setzt X auf Timer, Timer zhlt automatisch hoch
y = Timer                                       ' setzt X auf Timer, Timer zhlt automatisch hoch
#schleife
if Timer = x then dp = on                       ' Dezimalpunkt einschalten
if Timer = x then a = on
if Timer = x then f = off                       ' Segment f aus
if Timer = x + 4 then b = on                    ' Balken b nach 0,16 Sekunden
if Timer = x + 4 then a = off                   ' Balken a aus nach 0,16 Sekunden
if Timer = x + 4 then dp = off
if Timer = x + 8 then c = on                    ' Balken c  usw.
if Timer = x + 8 then dp = on
if Timer = x + 8 then b = off
if Timer = x + 12 then d = on
if Timer = x + 12 then c = off
if Timer = x + 12 then dp = off
if Timer = x + 16 then e = on
if Timer = x + 16 then dp = on
if Timer = x + 16 then d = off
if Timer = x + 20 then f = on
if Timer = x + 20 then e = off
if Timer = x + 20 then dp = off
if Timer = x + 24 then x = timer                ' 1. Timer Neustart
if Timer = y + 72 then goto weiter1             ' 2. Timer zhlt hoch - Dauer der Umlufe
goto schleife                                   ' sind nicht alle Durchlufe absolviert, dann von vorn
#weiter1
f = off
dp = off
RETURN
END FUNC
'---------------------------------------------------------------------------------------

'--- Leerlauf --------------------------------------------------------------------------
' Es wird eine 0 auf dem Display angezeigt.
'--------------------
FUNC Leerlauf
  k = 0
  a = on
  b = on
  c = on
  d = on
  e = on
  f = on
  g = off
  RETURN
END FUNC
'---------------------------------------------------------------------------------------


'--- Gang 1 ----------------------------------------------------------------------------
' Es wird eine 1 auf dem Display angezeigt.
'--------------------
FUNC Gang_1
  k = 1
  a = off
  b = on
  c = on
  d = off
  e = off
  f = off
  g = off
  RETURN
END FUNC
'---------------------------------------------------------------------------------------


'--- Gang 2 ----------------------------------------------------------------------------
' Es wird eine 2 auf dem Display angezeigt.
'--------------------
FUNC Gang_2
  k = 2
  a = on
  b = on
  c = off
  d = on
  e = on
  f = off
  g = on
  RETURN
END FUNC
'---------------------------------------------------------------------------------------


'--- Gang 3 ----------------------------------------------------------------------------
' Es wird eine 3 auf dem Display angezeigt.
'--------------------
FUNC Gang_3
  k = 3
  a = on
  b = on
  c = on
  d = on
  e = off
  f = off
  g = on
  RETURN
END FUNC
'---------------------------------------------------------------------------------------


'--- Gang 4 ----------------------------------------------------------------------------
' Es wird eine 4 auf dem Display angezeigt.
'--------------------
FUNC Gang_4
  k = 4
  a = off
  b = on
  c = on
  d = off
  e = off
  f = on
  g = on
  RETURN
END FUNC
'---------------------------------------------------------------------------------------


'--- Gang 5 ----------------------------------------------------------------------------
' Es wird eine 5 auf dem Display angezeigt.
'--------------------
FUNC Gang_5
  k = 5
  a = on
  b = off
  c = on
  d = on
  e = off
  f = on
  g = on
  RETURN
END FUNC
'---------------------------------------------------------------------------------------


'--- Gang 6 ----------------------------------------------------------------------------
' Es wird eine 6 auf dem Display angezeigt.
'--------------------
FUNC Gang_6
  k = 6
  a = on
  b = off
  c = on
  d = on
  e = on
  f = on
  g = on
  RETURN
END FUNC
'---------------------------------------------------------------------------------------

'---Initialisierung---------------------------------------------------------------------
' Es wird eine auf- und abschwellende 8 auf dem Display angezeigt.
'-------------------
FUNC Initial
  k = 0
  a = on
  b = on
  c = on
  d = on
  e = on
  f = on
  g = on
x = Timer                                       ' setzt X auf Timer, Timer zhlt automatisch hoch
y = Timer                                       ' setzt X auf Timer, Timer zhlt automatisch hoch
#schleife1
if Timer = x then tmp = 220                     ' LED abdunkeln 1. Schritt
pwm1 tmp
if Timer = x + 2 then tmp = 200                 ' LED abdunkeln 2. Schritt
pwm1 tmp
if Timer = x + 4 then tmp = 170                 ' LED abdunkeln 3. Schritt
pwm1 tmp
if Timer = x + 8 then tmp = 140                 ' LED abdunkeln 4. Schritt
pwm1 tmp
if Timer = x + 10 then tmp = 110                ' LED abdunkeln 5. Schritt
pwm1 tmp
if Timer = x + 12 then tmp = 80                 ' LED abdunkeln 6. Schritt
pwm1 tmp
if Timer = x + 14 then tmp = 110                ' LED abdunkeln 1. Schritt
pwm1 tmp
if Timer = x + 16 then tmp = 140                ' LED abdunkeln 2. Schritt
pwm1 tmp
if Timer = x + 18 then tmp = 170                ' LED abdunkeln 3. Schritt
pwm1 tmp
if Timer = x + 20 then tmp = 200                ' LED abdunkeln 4. Schritt
pwm1 tmp
if Timer = x + 22 then tmp = 220                ' LED abdunkeln 5. Schritt
pwm1 tmp
if Timer = x + 24 then tmp = 250                ' LED abdunkeln 6. Schritt
pwm1 tmp
if Timer = x + 26 then x = timer                ' 1. Timer Neustart
if Timer = y + 78 then goto weiter2             ' 2. Timer zhlt hoch - Dauer der Umlufe
goto schleife1                                  ' sind nicht alle Durchlufe absolviert, dann von vorn
#weiter2
  a = off
  b = off
  c = off
  d = off
  e = off
  f = off
  g = off
RETURN
End FUNC
'--------------------------------------------------------------------------------------

'--- Fehler ----------------------------------------------------------------------------
' Es wird ein E fr Error auf dem Display angezeigt
'--------------------
FUNC Fehler
  a = on
  b = off
  c = off
  d = on
  e = on
  f = on
  g = on
  RETURN
END FUNC
'---------------------------------------------------------------------------------------

'--- Licht an --------------------------------------------------------------------------
' der Dezimalpunkt leuchtet und das Relais wird angesteuert
'--------------------
FUNC Licht_on
  dp = on                                       ' Dezimalpunkt leuchtet
  Relais = on                                   ' Lichtrelais ansteuern
  RETURN
END FUNC
'---------------------------------------------------------------------------------------
'--- Licht aus --------------------------------------------------------------------------
' der Dezimalpunkt aus und das Relais aus
'--------------------
FUNC Licht_off
  dp = off                                      ' Dezimalpunkt aus
  Relais = off                                  ' Lichtrelais ausschalten
  RETURN
END FUNC
'---------------------------------------------------------------------------------------

'--- Schaltblitz -----------------------------------------------------------------------
Func Blitz
  Schaltblitz = on
  pause 4                                       ' Blitz fr 0,08 Sekunden aktiv
  Schaltblitz = off
  Return
End FUNC

end                                             ' Programmende

' ---------------------------------------------------------------------------
' --- PWM-Routinen fr Port1 ------------------------------------------------
' ---------------------------------------------------------------------------
TABLE pwm1_ein byte    ' PWM Port1 einschalten
  &h12 &h06
  &h1a &h20 &h18 &h20 &h3f &h26 &h3f &h27 &ha6 &h1a &hb7 &h25 &h1b &h20 &h81
TABEND
' ---------------------------------------------------------------------------
TABLE pwm1 byte        ' PWM Port1 setzten - Uebergabe als Argument
  &h12 &h06
  &had &h13 &ha1 &hfa &h25 &h03 &h10 &h25 &h81 &h5f &h48 &h59 &h48 &h59 &hbf &h26
  &hb7 &h27 &h11 &h25 &h81 &hae &h01 &h83
TABEND
' ---------------------------------------------------------------------------
TABLE pwm1_aus byte    ' PWM Port1 ausschalten
  &h12 &h06
  &h1a &h20 &h18 &h20 &h3f &h25 &h1b &h20 &h81
TABEND
' ---------------------------------------------------------------------------

'*** Beschreibung **************************************************************************************
'--- Spannungsmessung Gangsensor ---
'Wegen der etwas ber 5 Volt liegenden Spannung ist die Spannung heruntergeteilt mit dem Faktor 0,9412.
'Damit wird die Messspannung niemals ber 5 Volt liegen. Die Triggerwerte sind darauf angepat.
'Die Spannung wird in 0,02 Volt Schritten aufgelst. Geht also bis maximal 250.

'--- Freq ----
'Mit dieser internen Variable kann die Frequenz am FREQ-Pin (PORT[3]) abgefragt werden.
'Die Messung erfolgt im Hintergrund, parallel zur Programmausfhrung. Die Frequenzmessung
'wird erst aktiviert, nachdem die Torzeit (Mezeit) eingestellt wurde. 
'Die Torzeit wird in 20-ms-Schritten angegeben und wird erst nach Ablauf der vorherigen wirksam.
'Durch "FREQ=0" oder "FREQ=OFF" lt sich die Frequenzmessung deaktivieren. Whrend BEEP, GET, INPUT
'und SLOWMODE werden alle Interrupts deaktiviert und deshalb wird auch FREQ nicht mehr aktualisiert.
'Zurckgeliefert wird die Anzahl der innerhalb der Mezeit aufgetretenen Impulse. Und zwar wird bei
'jeder fallenden Flanke am KBI2-Pin (liegt am gleichen Pin wie PORT[3]) ein Interrupt ausgelst.
'Die Frequenz, gezhlt in Impulse pro Sekunde, lt sich daraus berechnen zu

     ' f = FREQ / MESSZEIT.

'Achtung: Nach einem Reset mu PORT[3] auf High-Potential (5 Volt) liegen, sonst geht der Kontroller
'in den Hostmodus und arbeitet das BASIC-Programm nicht ab.


'---Verfgbarkeit----
'Open-Micro: an PORT[3]
'Open-Mini:  an PORT[3]
'Open-Midi:  an PORT[3]

'---Syntax----
'FREQ
'FREQ1

'---Beispiel----
'FREQ = 50    'Torzeit, bzw. Mezeit: 1 Sekunde

'gemessen - 22 Hz entspricht 2800 Umdrehungen

